/* ============ */
/* cpnchisq.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include <cupndefs.h>
#include <assert.h>

static long CouponCtrs[MAX_COUPON_LEN];
/* ==================================================================== */
/* CollectCouponSet - Collects Complete Set of Coupons			*/
/* ==================================================================== */
static void
CollectCouponSet(COUPON_DATA_STRU * CouponData)
{
    int     CouponCt = 0, SegSize;

    /* -------------------------------------- */
    /* Clear Coupon Counters & Variate Counts */
    /* -------------------------------------- */
    memset(CouponCtrs, 0, sizeof(CouponCtrs));
    CouponData->TotNumGen    = 0;
    CouponData->ActMaxPerSeg = 0;

    do
    {
	/* ------------------- */
	/* Generate New Coupon */
	/* ------------------- */
	SegSize = GenCouponData(CouponData);

	/* ---------------------------------- */
	/* Record Actual Maximum Segment Size */
	/* ---------------------------------- */
	if (SegSize > CouponData->ActMaxPerSeg)
	{
	    CouponData->ActMaxPerSeg = SegSize;
	}

	/* ------------------------------ */
	/* Bump Number Variates Generated */
	/* ------------------------------ */
	CouponData->TotNumGen += SegSize;

	if (!CouponData->CallStatusOK)
	{
	    break;
	}

	/* -------------------------------- */
	/* Lump Count of Segments > Maximum */
	/* -------------------------------- */
	if (SegSize > CouponData->MaxCpnLen)
	{
	    SegSize = CouponData->MaxCpnLen;
	}
	assert(SegSize - CouponData->SetSize < MAX_COUPON_LEN);

	++CouponCtrs[SegSize - CouponData->SetSize];
	++CouponCt;
    }
    while (CouponCt < CouponData->NumCoupons);
}
/* ======================================================================= */
/* CalcCouponChiSq - Gets Chi-Square Statistic for Coupon Collector's Test */
/* ======================================================================= */
void
CalcCouponChiSq(COUPON_DATA_STRU * CouponData)
{
    CollectCouponSet(CouponData);

    if (CouponData->CallStatusOK)
    {
	int	j;

	/* --------------------------- */
	/* Lump Categories as Required */
	/* --------------------------- */
	for (j = 0; j < CouponData->NotEnough; ++j)
	{
	    CouponCtrs[j + 1] += CouponCtrs[j];
	}

	/* ------------------------------ */
	/* Calculate Chi-Square Statistic */
	/* ------------------------------ */
	CouponData->CouponChiSq = 0;

	for (j = CouponData->NotEnough; j < CouponData->NumCategories; ++j)
	{
	    if (CouponCtrs[j])
	    {
		CouponData->CouponChiSq +=
		    SQR((double) CouponCtrs[j]) / CouponData->CellExpect[j];
	    }
	    P(printf("\tCouponCtrs[%2d] = %ld\tCouponChiSq = %.15e\n",
		j, CouponCtrs[j], CouponData->CouponChiSq));
	}

	CouponData->CouponChiSq -= CouponData->NumCoupons;
    }
    else
    {
	printf("Chi-Square Process Failed\n");
    }
}
